<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Vendas - VP Empresas";
$meta_description = "";
$meta_canonical = "https://parceiros.vamosparcelar.com.br/vendas";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/vendas.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide vendas" data-menu="vendas" data-route="vendas">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main">
        <div class="inner-container">
            <h3 class="title">Histórico de vendas</h3>
            <section class="filtros">
                <div class="card">
                    <div class="conteudo">
                        <div class="flex">
                            <form class="form" id="formPesquisaLivre">
                                <div class="fields">
                                    <div class="row">
                                        <div class="input-content">
                                            <input required type="text" name="pesquisa_livre" id="pesquisaLivre" data-key="live" class="input icon-right">
                                            <label for="pesquisaLivre">Localizador ou ID</label>
                                            <button class="icon right action" id="filtraPesquisaLivre">
                                                <span class="material-icons-round">search</span>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                            <div class="btns auto-width">
                                <button class="botao primary neutral auto-width" id="reloadTransactions">
                                    <span class="icon"><span class="material-icons-round">sync</span></span>
                                    <span class="text">Atualizar</span>
                                </button>
                                <button class="botao primary neutral auto-width" id="abreFiltros">
                                    <span class="icon"><span class="material-icons-round">filter_alt</span></span>
                                    <span class="text">Filtros</span>
                                </button>
                            </div>
                        </div>
                        <div class="filtros-bar">
                            <form class="form" id="formAplicaFiltros">
                                <div class="flex">
                                    <div class="group">
                                        <p>Período</p>
                                        <div class="form">
                                            <div class="fields">
                                                <div class="row">
                                                    <div class="input-content">
                                                        <select class="select wide" id="selectPeriod">
                                                            <option value="todo">Todo o período</option>
                                                            <option value="0">Hoje</option>
                                                            <option value="7">Últimos 7 dias</option>
                                                            <option value="15">Últimos 15 dias</option>
                                                            <option value="30">Últimos 30 dias</option>
                                                            <option value="60">Últimos 60 dias</option>
                                                            <option value="90">Últimos 90 dias</option>
                                                            <option value="personalizado">Personalizado</option>
                                                        </select>
                                                    </div>
                                                    <div class="input-content formPeriodo" id="inputSelecionaData">
                                                        <input disabled readonly type="text" class="input input-date icon-right select-read" id="datasPeriodo">
                                                        <!-- <label for="datasPeriodo">Intervalo de busca</label> -->
                                                        <div class="icon right">
                                                            <span class="material-icons-round">calendar_month</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="group">
                                        <p>Status de pagamento</p>
                                        <div class="form">
                                            <div class="fields">
                                                <div class="row">
                                                    <div class="input-content">
                                                        <select class="select wide" id="selectStatus">
                                                            <option value="TODOS">Todos</option>
                                                            <option value="PENDENT">Pendente</option>
                                                            <option value="PROCESSING_PAYMENT">Processando</option>
                                                            <option value="AUTHORIZED">Autorizado</option>
                                                            <option value="PAID">Pago</option>
                                                            <option value="DENIED">Não autorizado</option>
                                                            <option value="REFUSED">Rejeitado</option>
                                                            <option value="REFUNDED">Reembolsado</option>
                                                            <option value="CHARGEBACK">Chargeback</option>
                                                            <option value="UNPROCESSED_PAYMENT">Não processado</option>
                                                            <option value="VOID">Recusado</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="btns mt-3">
                                    <button class="botao primary neutral auto-width" id="aplicaFiltros">
                                        <span class="text">Aplicar filtros</span>
                                    </button>
                                    <button type="button" class="botao secondary auto-width" id="resetaFiltros">
                                        <span class="text">Limpar</span>
                                    </button>
                                </div>
                            </form>

                        </div>
                    </div>
                </div>
            </section>
            <section class="numbers">
                <div class="card">
                    <div class="conteudo">
                        <div class="label">Valor transacionado</div>
                        <div class="big totalAmount"></div>
                        <div class="load load-historico"></div>
                    </div>
                </div>
                <div class="card">
                    <div class="conteudo">
                        <div class="label">Número de transações</div>
                        <div class="big totalDocs"></div>
                        <div class="load load-historico"></div>
                    </div>
                </div>
                <div class="card">
                    <div class="conteudo">
                        <div class="label">Página</div>
                        <div class="big totalPages"></div>
                        <div class="load load-historico"></div>
                    </div>
                </div>
            </section>
            <section class="historico" id="topTransactions">
                <div class="card">
                    <div class="conteudo">
                        <div class="transacoes">
                            <div class="transacao head">
                                <div class="info">
                                    <div class="chave">Localizador</div>
                                </div>
                                <div class="info">
                                    <div class="chave">Valor</div>
                                </div>
                                <div class="info">
                                    <div class="chave">Status</div>
                                </div>
                                <div class="info">
                                    <div class="chave">Data e hora</div>
                                </div>
                                <!-- <div class="info">
                                    <div class="chave">ID da transação</div>
                                </div> -->
                            </div>
                            <div class="load center load-historico" id="loadHistorico"></div>
                            <div class="transactionsList"></div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="pagination sticky">
                <div class="cards row center">
                    <div class="card center flex">
                        <button disabled class="botao primary auto-width" id="btnPrimeiraPagina">
                            <div class="icon"><span class="material-icons-round">keyboard_double_arrow_left</span></div>
                            <div class="text">Primeira</div>
                        </button>
                        <button disabled class="botao primary auto-width" id="btnPaginaAnterior">
                            <div class="icon"><span class="material-icons-round">keyboard_arrow_left</span></div>
                            <div class="text">Anterior</div>
                        </button>
                        <button disabled class="botao primary auto-width" id="btnProximaPagina">
                            <div class="text">Próxima</div>
                            <div class="icon"><span class="material-icons-round">keyboard_arrow_right</span></div>
                        </button>
                        <button disabled class="botao primary auto-width" id="btnUltimaPagina">
                            <div class="text">Última</div>
                            <div class="icon"><span class="material-icons-round">keyboard_double_arrow_right</span></div>
                        </button>
                    </div>
                </div>
            </section>
        </div>
        <?php require_once("model/body/modal_dados_transacao.php"); ?>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>