<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Políticas e Termo - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/termos.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="termos" data-route="termos">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main termos">
        <div class="inner-container">
            <div class="title-flex">
                <h3 class="title">
                    Políticas e Termos
                    <span class="numeroCadastrados">0</span>
                </h3>
                <div class="botao primary auto-width abre-modal" id="btnCadastrarTermo">
                    <span class="load" id="load"></span>
                    <span class="text">Adicionar</span>
                </div>
            </div>
            <section class="estabelecimentos-list">
                <div class="card">
                    <div class="empty hide">
                        <?php require_once("./assets/img/empty_search.svg"); ?>
                        <p>As perguntas aparecerão aqui quando forem cadastrados</p>
                    </div>
                    <div class="load-alt center" id="loadTermo"></div>
                    <div class="table-scroll hide" id="tableTermo">
                        <table>
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Título</th>
                                    <th>Data de atualização</th>
                                    <th>Status</th>
                                    <th>Anexo</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody id="listaTermo"></tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>
<?php require_once("model/body/modal_cadastro_termos.php"); ?>
<?php require_once("model/body/modal_dados_termo.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>