$(function(){

    recuperaMenus();
    recuperaDados();
    validationForm("formNovoTermo");
    verificaInputsRequired("formNovoTermo");
    validationForm("formDadosTermo");
    verificaInputsRequired("formDadosTermo");

    var toolbarOptions = [
        [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
        ['bold', 'italic', 'underline', 'strike'],
        ['link'],
        [{ 'list': 'ordered'},{'list':'bullet'}, { 'align': []}],
        ['clean']
    ];

    var options = {
        placeholder: 'Digite a resposta...',
        theme: 'snow',
        modules: {
            toolbar: toolbarOptions
        }
    };

    var quill = new Quill(".editor", options);

    var quillDados = new Quill(".editor-dados", options);


    // abre modal de cadastrar termo
    $("#btnCadastrarTermo").click(function () {
        abreModal("modalNovoTermo");
    });

    $("#fechaModalNovoTermo").click(() => {
        $("#modalNovoTermo").hide();
    });

    $("body").on("keyup click",".editor .ql-editor", function(){
        $("#callback_termo").val($(this).html());
        if($("#callback_termo").val() == "<p><br></p>"){
            $("#btnCadastraTermo").attr("disabled", true);
        }else{
            $("#btnCadastraTermo").attr("disabled", false);
        }
    });

    $("body").on("keyup click",".editor-dados .ql-editor", function(){
        $("#callback_termo_dados").val($(this).html());
        if($("#callback_termo_dados").val() == "<p><br></p>"){
            $("#btnAtualizaTermo").attr("disabled", true);
        }else{
            $("#btnAtualizaTermo").attr("disabled", false);
        }
    });

    function sendFetchDados() {
        $("#btnCadastraTermo .load").show();
        $("#btnCadastraTermo .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formNovoTermo").submit(function (e) {
        e.preventDefault();

        sendFetchDados("./controller/cadastra_termo.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnCadastraTermo .text").show();
                $("#btnCadastraTermo .load").hide();
                return;
            }
            
            $("#btnCadastraTermo .text").show();
            $("#btnCadastraTermo .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $('#formNovoTermo')[0].reset();
            $(".editor .ql-editor").html("");
            $("#formNovoTermo input").removeClass("input-active");
            $(".modal").hide();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    function sendFetchDetalhes() {
        $("#modalDadosTermo .load-detalhes").show();
        return fetch.apply(this, arguments);
    }

    $("#listaTermo").on("click",".abre-detalhes", function () {

        abreModal("modalDadosTermo");
        const idTermo = $(this).closest("tr").data("id");

        sendFetchDetalhes("./controller/consulta_termo.php?id="+idTermo).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            $("#field_titulo_dados").val(dados.titulo).addClass("input-active");
            $("#modalDadosTermo .ql-editor").html(dados.termo);
            $("#modalDadosTermo #callback_termo_dados").val(dados.termo);

            let status;
            dados.status === "0" ? status = "Inativo" : status = "Ativo";

            $("#field_hidden_status").val(dados.status);
            $("#radiosAlteraStatus .radio").removeClass("ativo");
            $(`#radiosAlteraStatus .radio .label:contains(${status})`).closest(".radio").addClass("ativo");

            if(dados.anexo != null && dados.anexo != "" && dados.anexo.length != 0){
                let fileName = dados.anexo.split("/")[3];

                if(fileName.length >= 24){
                    fileName = fileName.substring(0,12) + "..." + fileName.substring(fileName.length - 12);
                }

                $("#field_arquivo_dados").closest(".label-upload").next().parent().find(".path").text(fileName);
                $("#field_arquivo_dados").closest(".label-upload").next().show().css("display", "flex");
            }

            $("#btnAtualizaTermo").data("id", dados.id);
            
            $("#modalDadosTermo .load-detalhes").hide();
            $("#formDadosTermo").show();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#fechaModalDadosTermo").click(() => {
        closeModalTermo();
    });

    function closeModalTermo(){
        $("#modalDadosTermo .load-detalhes").show();
        $("#modalDadosTermo").hide();
        $("#formDadosTermo").hide();
    }

    $("#radiosAlteraStatus .radio").on("click", function(){
        const option = $(this).data("option");
        $("#field_hidden_status").val(option);
        $("#radiosAlteraStatus .radio").removeClass("ativo");
        $(this).addClass("ativo");
        $("#btnAtualizaTermo").attr("disabled", false);
    });

    function sendFetchAtualizaDados() {
        $("#btnAtualizaTermo .load").show();
        $("#btnAtualizaTermo .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formDadosTermo").submit(function (e) {
        e.preventDefault();

        const idTermo = $("#btnAtualizaTermo").data("id");

        sendFetchAtualizaDados("./controller/atualiza_dados_termo.php?id="+idTermo, {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAtualizaTermo .text").show();
                $("#btnAtualizaTermo .load").hide();
                return;
            }
            
            $("#btnAtualizaTermo .text").show();
            $("#btnAtualizaTermo .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            closeModalTermo();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    let fileInput = $(".label-upload input");

    fileInput.on("change", function({target}){
        let file = target.files[0];

        console.log(file);
        if(file){
            let fileName = file.name;
            let fileSize = file.size / 1024;

            if(fileSize > 15360) {
                $(".msg").addClass("on");
                $(".msg .text").text("Escolha um arquivo menor que 15 MB");
                return;
            }

            if(fileName.length >= 24){
                fileName = fileName.substring(0,12) + "..." + fileName.substring(fileName.length - 12);
            }

            $("#"+target.id).closest(".label-upload").next().parent().find(".path").text(fileName);
            $("#"+target.id).closest(".label-upload").next().parent().find("img").attr("src",URL.createObjectURL(file));
            $("#"+target.id).closest(".label-upload").next().show().css("display", "flex");
        }
        
    });

    $(".delete").on("click", function(){
        $(this).closest(".flex-upload").parent().find("input").val("");
        $(this).next().val("sim");
        $(this).closest(".logo-preview").hide();
    });

    $("body").on("click",".categoria", function () {
        $(".categoria").removeClass("ativo");
        $(this).addClass("ativo");
        let id = $(this).data("id");
        recuperaDadosTermo(id);
    });

});