$(function(){

    recuperaMenus();
    recuperaDados();
    validationForm("formNovoRecado");
    verificaInputsRequired("formNovoRecado");
    validationForm("formDadosRecado");
    verificaInputsRequired("formDadosRecado");

    $(".texto-recado").each(function(){
        if($(this).text().length >= 150){
            $(this).text($(this).text().substring(0,147) + "...");
        }
    });

    var toolbarOptions = [
        [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
        ['bold', 'italic', 'underline', 'strike'],
        ['link'],
        [{ 'list': 'ordered'},{'list':'bullet'}, { 'align': []}],
        ['clean']
    ];

    var options = {
        placeholder: 'Digite o recado...',
        theme: 'snow',
        modules: {
            toolbar: toolbarOptions
        }
    };

    var quill = new Quill(".editor", options);

    var quillDados = new Quill(".editor-dados", options);


    // abre modal de cadastrar estabelecimento
    $("#btnCadastrarRecado").click(function () {
        abreModal("modalNovoRecado");
    });

    $("#fechaModalNovoRecado").click(() => {
        $("#modalNovoRecado").hide();
    });

    $("body").on("keyup click",".editor .ql-editor", function(){
        $("#callback_recado").val($(this).html());
        if($("#callback_recado").val() == "<p><br></p>"){
            $("#btnCadastraRecado").attr("disabled", true);
        }else{
            $("#btnCadastraRecado").attr("disabled", false);
        }
    });

    $("body").on("keyup click",".editor-dados .ql-editor", function(){
        $("#callback_recado_dados").val($(this).html());
        if($("#callback_recado_dados").val() == "<p><br></p>"){
            $("#btnAtualizaRecado").attr("disabled", true);
        }else{
            $("#btnAtualizaRecado").attr("disabled", false);
        }
    });

    let fileInput = $(".label-upload input");

    fileInput.on("change", function({target}){
        let file = target.files[0];
        if(file){
            let fileName = file.name;
            let fileSize = file.size / 1024;

            if(fileSize > 15360) {
                $(".msg").addClass("on");
                $(".msg .text").text("Escolha um arquivo menor que 15 MB");
                return;
            }

            if(fileName.length >= 16){
                fileName = fileName.substring(0,8) + "..." + fileName.substring(fileName.length - 8);
            }

            $("#"+target.id).closest(".label-upload").next().parent().find(".path").text(fileName);
            $("#"+target.id).closest(".label-upload").next().parent().find("img").attr("src",URL.createObjectURL(file));
            $("#"+target.id).closest(".label-upload").next().show().css("display", "flex");
        }
        
    });

    $(".delete").on("click", function(){
        $(this).closest(".flex-upload").parent().find("input").val("");
        $(this).next().val("sim");
        $(this).closest(".logo-preview").hide();
    });

    function sendFetchDados() {
        $("#btnCadastraRecado .load").show();
        $("#btnCadastraRecado .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formNovoRecado").submit(function (e) {
        e.preventDefault();

        if($("#field_titulo").val().length === 0){
            $("#field_titulo").val($("#callback_recado").val().replace(/<[^>]*>/g," ").replace(/\s{2,}/g," ").trim().split(".")[0]).addClass("input-active");
        }

        sendFetchDados("./controller/cadastra_recado.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnCadastraRecado .text").show();
                $("#btnCadastraRecado .load").hide();
                return;
            }
            
            $("#btnCadastraRecado .text").show();
            $("#btnCadastraRecado .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    function sendFetchDetalhes() {
        $("#modalDadosRecado .load-detalhes").show();
        return fetch.apply(this, arguments);
    }

    $("#listaRecados").on("click",".abre-detalhes", function () {

        abreModal("modalDadosRecado");
        const idEstabelecimento = $(this).closest("tr").data("id");

        sendFetchDetalhes("./controller/consulta_recado.php?id="+idEstabelecimento).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            console.log(dados);

            $("#field_titulo_dados").val(dados.titulo).addClass("input-active");
            $("#modalDadosRecado .ql-editor").html(dados.recado);
            $("#modalDadosRecado #callback_recado_dados").val(dados.recado);

            if(dados.link != null && dados.link != "" && dados.link.length != 0){
                $("#field_link_dados").val(dados.link).addClass("input-active");
            }else{
                $("#field_link_dados").val("").removeClass("input-active");
            };

            if(dados.arquivo != null && dados.arquivo != "" && dados.arquivo.length != 0){
                let splitNameArquivo = dados.arquivo.split("/")[4].split(".");
                var fileNameArquivo = splitNameArquivo[0].substring(0,12) + "... ." + splitNameArquivo[1];
                $("#field_arquivo_dados").closest(".label-upload").next().parent().find(".path").text(fileNameArquivo);
                $("#field_arquivo_dados").closest(".label-upload").next().show().css("display", "flex");
            }
            
            if(dados.imagem != null && dados.imagem != "" && dados.imagem.length != 0){
                $("#field_imagem_dados").closest(".label-upload").next().parent().find("img").attr("src",dados.imagem);
                $("#field_imagem_dados").closest(".label-upload").next().show().css("display", "flex");
            }
            

            $("#btnAtualizaRecado").data("id", dados.id);
            
            $("#modalDadosRecado .load-detalhes").hide();
            $("#formDadosRecado").removeClass("hide");

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#fechaModalDadosRecado").click(() => {
        closeModalRecado();
    });

    function closeModalRecado(){
        $("#modalDadosRecado .load-detalhes").show();
        $("#modalDadosRecado").hide();
        $("#formDadosRecado").addClass("hide");
    }

    function sendFetchAtualizaDados() {
        $("#btnAtualizaRecado .load").show();
        $("#btnAtualizaRecado .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formDadosRecado").submit(function (e) {
        e.preventDefault();

        const idRecado = $("#btnAtualizaRecado").data("id");

        sendFetchAtualizaDados("./controller/atualiza_recado.php?id="+idRecado, {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAtualizaRecado .text").show();
                $("#btnAtualizaRecado .load").hide();
                return;
            }
            
            $("#btnAtualizaRecado .text").show();
            $("#btnAtualizaRecado .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            closeModalRecado();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#listaRecados").on("click",".exclui-recado", function () {
        const idRecado = $(this).closest("tr").data("id");
        $("#btnExcluiRecado").data("id",idRecado);
        abreModal("modalExcluiRecado");
    });

    $("#btnFechaModalExcluiRecado").click(()=>{
        $("#modalExcluiRecado").hide();
    });

    function sendFetchExcluiRecado() {
        $("#btnExcluiRecado .load").show();
        $("#btnExcluiRecado .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#btnExcluiRecado").click(function (e) {
        e.preventDefault();

        const idRecado = $(this).data("id");

        sendFetchExcluiRecado("./controller/deleta_recado.php?id="+idRecado).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnExcluiRecado .text").show();
                $("#btnExcluiRecado .load").hide();
                return;
            }
            
            $("#btnExcluiRecado .text").show();
            $("#btnExcluiRecado .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

});