$(function () {

    recuperaMenus();
    recuperaDados();
    validationForm("formNovoPortal");
    verificaInputsRequired("formNovoPortal");
    validationForm("formDadosPortal");
    verificaInputsRequired("formDadosPortal");

    // abre modal de cadastrar portal
    $("#btnCadastrarPortal").click(function () {
        abreModal("modalNovoPortal");
    });

    $("#fechaModalNovoPortal").click(() => {
        $("#modalNovoPortal").hide();
    });

    $("#pesquisaLivre").on("input change", function () {
        $(".portais-list li").removeClass("result-on");

        if ($(this).val() != "") {
            $(".portais-list li").hide();
            $(".portais-list li:contains-ci('" + $(this).val() + "')").show().addClass("result-on");
            contaResultados();
        } else {
            $(".portais-list li").show();
            $(".card-lista-portais").show();
            $("#emptyPortais").addClass("hide");
        }

        if($(this).val() === "Todos") {
            $(".portais-list li").show();
            $("#emptyPortais").addClass("hide");
            $(".portais-list").show();
        }
    });

    $("#pesquisaLivreCards").on("input change", function () {
        $(".portais-list-flex .card").removeClass("result-on");

        if ($(this).val() != "") {
            $(".portais-list-flex .card").hide();
            $(".portais-list-flex .card:contains-ci('" + $(this).val() + "')").show().addClass("result-on");
            contaResultados();
        } else {
            $(".portais-list-flex .card").show();
        }
    });

    function contaResultados() {
        var resultados = $(".result-on").length;
        if (resultados === 0) {
            $("#emptyPortais").removeClass("hide");
            $(".card-lista-portais").hide();
        } else {
            $("#emptyPortais").addClass("hide");
            $(".card-lista-portais").show();
        }
    }

    $.extend($.expr[":"], {
        "contains-ci": function (elem, i, match, array) {
            return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
        }
    });

    function sendFetchDados() {
        $("#btnCadastraPortal .load").show();
        $("#btnCadastraPortal .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formNovoPortal").submit(function (e) {
        e.preventDefault();

        sendFetchDados("./controller/cadastra_portal.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnCadastraPortal .text").show();
                $("#btnCadastraPortal .load").hide();
                return;
            }
            
            $("#btnCadastraPortal .text").show();
            $("#btnCadastraPortal .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            $("#formNovoPortal")[0].reset();
            $(".modal").hide();

            recuperaDados();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    function sendFetchDetalhes() {
        $("#modalDadosPortal .load-detalhes").show();
        return fetch.apply(this, arguments);
    }

    $(".portais-list").on("click",".abre-detalhes", function () {

        abreModal("modalDadosPortal");
        const idPortal = $(this).closest("li").data("id");

        sendFetchDetalhes("./controller/consulta_portal.php?id="+idPortal).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            $("#field_nome_dados").val(dados.nome).addClass("input-active");
            $("#field_link_dados").val(dados.link).addClass("input-active");

            let status;
            dados.status === "0" ? status = "Inativo" : status = "Ativo";

            $("#field_hidden_status").val(dados.status);
            $("#radiosAlteraStatus .radio").removeClass("ativo");
            $(`#radiosAlteraStatus .radio .label:contains(${status})`).closest(".radio").addClass("ativo");

            verificarInputsPreenchidos("formDadosPortal");

            $("#btnAtualizaPortal").data("id", dados.id);
            $("#modalDadosPortal .load-detalhes").hide();
            $("#formDadosPortal").show();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#fechaModalDadosPortal").click(() => {
        closeModalPortal();
    });

    function closeModalPortal(){
        $("#modalDadosPortal, #formDadosPortal").hide();
        $("#modalDadosPortal .load-detalhes").show();
        $("#btnAtualizaPortal").attr("disabled", true);
    }

    $("#radiosAlteraStatus .radio").on("click", function(){
        const option = $(this).data("option");
        $("#field_hidden_status").val(option);
        $("#radiosAlteraStatus .radio").removeClass("ativo");
        $(this).addClass("ativo");
        $("#btnAtualizaPortal").attr("disabled", false);
    });

    function sendFetchAtualizaDados() {
        $("#btnAtualizaPortal .load").show();
        $("#btnAtualizaPortal .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formDadosPortal").submit(function (e) {
        e.preventDefault();

        const idPortal = $("#btnAtualizaPortal").data("id");

        sendFetchAtualizaDados("./controller/atualiza_dados_portal.php?id="+idPortal, {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAtualizaPortal .text").show();
                $("#btnAtualizaPortal .load").hide();
                return;
            }
            
            $("#btnAtualizaPortal .text").show();
            $("#btnAtualizaPortal .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

});