$(function () {

    recuperaMenus();
    recuperaDados();

    validationForm("formDadosUser");
    validationForm("formAlterarSenha");
    validationForm("formAtualizaEmail");

    //ações de abrir e fechar o modal de pesquisa de bancos
    $(".abre-modal").click(() => {
        abreModal("modalAtualizaEmail");
        $("#field_novo_email").focus();
    });

    $("#fechaModalAtualizaEmail, #fechaModalAtualizaEmailToken").click(() => {
        $("#modalAtualizaEmail").hide();
        $("#boxToken").addClass("hide");
        $("#boxEmail").removeClass("hide");
        $("#formConfirmaAlteracaoEmail")[0].reset();
        $("#formAtualizaEmail")[0].reset();
    });

    $("#uploadPhoto").on("change", function(){
        const urlImage = previewImageUpload("#uploadPhoto");
        const imgPreview = $("#imgPerfil");
        const deleteBtn = $("#deleteImage");

        if(!urlImage) return;

        imgPreview.attr("src", urlImage);
        contaErros("formDadosUser");
        deleteBtn.removeClass("hide");
    });

    $("#deleteImage").click(function(){
        const imgPreview = $("#imgPerfil");
        var baseImage = "./assets/img/default_profile.svg";

        imgPreview.attr("src", baseImage);
        $("#uploadPhoto").val("");
        contaErros("formDadosUser");
        $(this).addClass("hide");

        $("#delete_photo").val("sim");
    });

    // atualizar dados do usuário
    function sendFetchDados() {
        $("#loadSubmit").show();
        $("#btnAtualizaDados .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formDadosUser").submit(function (e) {
        e.preventDefault();

        sendFetchDados("./controller/atualiza_dados_perfil.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
            }
            
            $("#btnAtualizaDados .text").show();
            $("#loadSubmit").hide();

            $("#btnAtualizaDados").attr("disabled", true);

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            $(".container").addClass("hide");

            recuperaDados();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#field_nova_senha").on("keyup", function () {
        validaSenha("#btnAtualizaSenha","#field_nova_senha");
    });

    // atualizar senha
    function sendFetchSenha() {
        $("#loadSalvarSenha").show();
        $("#btnAtualizaSenha .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formAlterarSenha").submit(function (e) {
        e.preventDefault();

        var ec = $("#ec_usuario_logado").val();

        sendFetchSenha("./controller/atualiza_senha_usuario.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code === 502) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#field_senha").addClass("field-error");
                $("#btnAtualizaSenha .text").show();
                $("#loadSalvarSenha").hide();
                return;
            }

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                return;
            }
            
            $("#btnAtualizaSenha .text").show();
            $("#loadSalvarSenha").hide();

            $("#btnAtualizaSenha").attr("disabled", true);

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            $(".container").addClass("hide");
            $(".loading").show();

            setTimeout(function() {
                location.href = "./login?ec="+ec;
            }, 1500);

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#token").on("input", function(){
        if($(this).val().length === 6) {
            $("#btnConfirmaAlteracaoEmail").removeAttr("disabled");
        }else{
            $("#btnConfirmaAlteracaoEmail").attr("disabled", true);
        }
    });

    function contador(time, botao){
        $("#"+botao).attr("disabled", true).removeClass("cont-finish");
        $("#"+botao+" .text u").show().text("("+time+")");
        let cont = time;
        let interval = setInterval(function(){
            if(cont === 1) {
                clearInterval(interval);
                $("#"+botao).removeAttr("disabled").addClass("cont-finish");
                $("#"+botao+" .text u").hide();
                return;
            }else{
                cont--;
                $("#"+botao+" .text u").show().text("("+cont+")");
                $("#"+botao).attr("disabled", true).removeClass("cont-finish");
            }
        },1000);
    }

    // enviar token
    function sendFetchToken() {
        $("#load2FAEmail, #loadReenviarToken").show();
        $("#btnEnvia2FAEmail .text, #btnReenviarToken .text").hide();
        $("#btnReenviarToken").attr("disabled", true).removeClass("cont-finish");
        $("#btnReenviarToken .text u").show().text("");
        return fetch.apply(this, arguments);
    }

    function enviarToken2FA(form){
        const formulario = document.getElementById(form);
        sendFetchToken("./controller/gera_token_2fa.php", {
            method: 'POST',
            body: new FormData(formulario)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code === 502) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#field_novo_email").addClass("field-error");
                $("#btnEnvia2FAEmail .text").show();
                $("#load2FAEmail").hide();
                return;
            }

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                return;
            }
            
            $("#btnEnvia2FAEmail .text, #btnReenviarToken .text").show();
            $("#load2FAEmail, #loadReenviarToken").hide();
            $("#btnReenviarToken .text u").show();

            $("#btnEnvia2FAEmail").attr("disabled", true);

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            $(".email-envio").text($("#field_novo_email").val());
            $("#novo_email").val($("#field_novo_email").val());

            $("#field_novo_email").removeClass("field-error");

            $("#boxEmail").addClass("hide");
            $("#boxToken").removeClass("hide");
            contador(30,"btnReenviarToken");

            $("#token").focus();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    }

    $("#formAtualizaEmail").submit(function (e) {
        e.preventDefault();
        enviarToken2FA("formAtualizaEmail");
    });

    $("#btnReenviarToken").click(function (e) {
        e.preventDefault();
        enviarToken2FA("formAtualizaEmail");
    });

    // alterar e-mail
    function sendFetchEmail() {
        $("#loadAlteracaoEmail").show();
        $("#btnConfirmaAlteracaoEmail .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formConfirmaAlteracaoEmail").submit(function (e) {
        e.preventDefault();

        sendFetchEmail("./controller/atualiza_email_usuario.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code === 502) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#token").addClass("field-error");
                $("#btnConfirmaAlteracaoEmail .text").show();
                $("#loadAlteracaoEmail").hide();
                return;
            }

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                return;
            }
            
            $("#btnConfirmaAlteracaoEmail .text").show();
            $("#loadAlteracaoEmail").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            setTimeout(function() {
                location.href = "./sair";
            }, 1500);

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    

    


});