$(function(){

    recuperaMenus();
    recuperaDados();
    validationForm("formNovoManual");
    verificaInputsRequired("formNovoManual");
    validationForm("formDadosManual");
    verificaInputsRequired("formDadosManual");

    var toolbarOptions = [
        [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
        ['bold', 'italic', 'underline', 'strike'],
        ['link'],
        [{ 'list': 'ordered'},{'list':'bullet'}, { 'align': []}],
        ['clean']
    ];

    var options = {
        placeholder: 'Descrição do manual...',
        theme: 'snow',
        modules: {
            toolbar: toolbarOptions
        }
    };

    var quill = new Quill(".editor", options);

    var quillDados = new Quill(".editor-dados", options);


    // abre modal de cadastrar estabelecimento
    $("#btnCadastrarManual").click(function () {
        abreModal("modalNovoManual");
    });

    $("#fechaModalNovoManual").click(() => {
        $("#modalNovoManual").hide();
    });

    $("body").on("keyup click",".editor .ql-editor", function(){
        $("#callback_manual").val($(this).html());
    });

    $("body").on("keyup click",".editor-dados .ql-editor", function(){
        $("#callback_manual_dados").val($(this).html());
        verificaInputsRequired("formDadosManual");
        verificarInputsObrigatorios("formDadosManual");
        verificarInputsPreenchidos("formDadosManual");
        validationForm("formDadosManual");
    });

    function sendFetchDados() {
        $("#btnCadastraManual .load").show();
        $("#btnCadastraManual .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formNovoManual").submit(function (e) {
        e.preventDefault();

        sendFetchDados("./controller/cadastra_manual.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnCadastraManual .text").show();
                $("#btnCadastraManual .load").hide();
                return;
            }
            
            $("#btnCadastraManual .text").show();
            $("#btnCadastraManual .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    function sendFetchDetalhes() {
        $("#modalDadosManual .load-detalhes").show();
        return fetch.apply(this, arguments);
    }

    $("#listaManual").on("click",".abre-detalhes", function () {

        abreModal("modalDadosManual");
        const idEstabelecimento = $(this).closest("tr").data("id");

        sendFetchDetalhes("./controller/consulta_manual.php?id="+idEstabelecimento).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            $("#field_titulo_dados").val(dados.titulo).addClass("input-active");
            $("#modalDadosManual .ql-editor").html(dados.descricao);
            $("#modalDadosManual #callback_manual_dados").val(dados.descricao);

            let status;
            dados.status === "0" ? status = "Inativo" : status = "Ativo";

            $("#field_hidden_status").val(dados.status);
            $("#radiosAlteraStatus .radio").removeClass("ativo");
            $(`#radiosAlteraStatus .radio .label:contains(${status})`).closest(".radio").addClass("ativo");

            if(dados.arquivo != null && dados.arquivo != "" && dados.arquivo.length != 0){
                let fileName = dados.arquivo.split("/")[4];

                if(fileName.length >= 24){
                    fileName = fileName.substring(0,12) + "..." + fileName.substring(fileName.length - 12);
                }

                $("#field_arquivo_dados").closest(".label-upload").next().parent().find(".path").text(fileName);
                $("#field_arquivo_dados").closest(".label-upload").next().show().css("display", "flex");
            }

            $("#btnAtualizaManual").data("id", dados.id);
            
            $("#modalDadosManual .load-detalhes").hide();
            $("#formDadosManual").removeClass("hide");

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#fechaModalDadosManual").click(() => {
        closeModalManual();
    });

    function closeModalManual(){
        $("#modalDadosManual .load-detalhes").show();
        $("#modalDadosManual").hide();
        $("#formDadosManual").addClass("hide");
        $("#btnAtualizaManual").attr("disabled", true);
    }

    function sendFetchAtualizaDados() {
        $("#btnAtualizaManual .load").show();
        $("#btnAtualizaManual .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formDadosManual").submit(function (e) {
        e.preventDefault();

        const idManual = $("#btnAtualizaManual").data("id");

        sendFetchAtualizaDados("./controller/atualiza_dados_manual.php?id="+idManual, {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAtualizaManual .text").show();
                $("#btnAtualizaManual .load").hide();
                return;
            }
            
            $("#btnAtualizaManual .text").show();
            $("#btnAtualizaManual .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            closeModalManual();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#listaManual").on("click",".exclui-manual", function () {
        const idManual = $(this).closest("tr").data("id");
        $("#btnExcluiManual").data("id",idManual);
        abreModal("modalExcluiManual");
    });

    $("#btnFechaModalExcluiManual").click(()=>{
        $("#modalExcluiManual").hide();
    });

    function sendFetchExcluiManual() {
        $("#btnExcluiManual .load").show();
        $("#btnExcluiManual .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#btnExcluiManual").click(function (e) {
        e.preventDefault();

        const idManual = $(this).data("id");

        sendFetchExcluiManual("./controller/deleta_manual.php?id="+idManual).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnExcluiManual .text").show();
                $("#btnExcluiManual .load").hide();
                return;
            }
            
            $("#btnExcluiManual .text").show();
            $("#btnExcluiManual .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#radiosAlteraStatus .radio").on("click", function(){
        const option = $(this).data("option");
        $("#field_hidden_status").val(option);
        $("#radiosAlteraStatus .radio").removeClass("ativo");
        $(this).addClass("ativo");
        $("#btnAtualizaManual").attr("disabled", false);
    });

    let fileInput = $(".label-upload input");

    fileInput.on("change", function({target}){
        let file = target.files[0];
        if(file){
            let fileName = file.name;
            let fileSize = file.size / 1024;

            if(file.type != "application/pdf") {
                $(".msg").addClass("on");
                $(".msg .text").text("Escolha um arquivo no formato PDF");
                return;
            }

            if(fileSize > 20480) {
                $(".msg").addClass("on");
                $(".msg .text").text("Escolha um arquivo menor que 20 MB");
                return;
            }

            if(fileName.length >= 24){
                fileName = fileName.substring(0,12) + "..." + fileName.substring(fileName.length - 12);
            }

            $("#"+target.id).closest(".label-upload").next().parent().find(".path").text(fileName);
            $("#"+target.id).closest(".label-upload").next().parent().find("img").attr("src",URL.createObjectURL(file));
            $("#"+target.id).closest(".label-upload").next().show().css("display", "flex");

            verificaInputsRequired("formNovoManual");
            verificaInputsRequired("formDadosManual");
            verificarInputsObrigatorios("formDadosManual");
            verificarInputsPreenchidos("formDadosManual");
            validationForm("formDadosManual");
        }
        
    });

    $(".delete").on("click", function(){
        $(this).closest(".flex-upload").parent().find("input").val("");
        $(this).closest(".logo-preview").hide();

        
        $("#btnCadastraManual, #btnAtualizaManual").attr("disabled", true);
    });

    $("#pesquisaLivreCards").on("input change", function () {
        $(".manuais-list-flex .card").removeClass("result-on");

        if ($(this).val() != "") {
            $(".manuais-list-flex .card").hide();
            $(".list-flex .card:contains-ci('" + $(this).val() + "')").show().addClass("result-on");
            contaResultados();
        } else {
            $(".manuais-list-flex .card, .manuais-list-flex").show();
            $("#emptyManual").addClass("hide");
        }
    });

    function contaResultados() {
        var resultados = $(".result-on").length;
        if (resultados === 0) {
            $("#emptyManual").removeClass("hide");
            $(".manuais-list-flex").hide();
        } else {
            $("#emptyManual").addClass("hide");
            $(".manuais-list-flex").show();
        }
    }

    $.extend($.expr[":"], {
        "contains-ci": function (elem, i, match, array) {
            return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
        }
    });

});