$(function(){

    validationForm("formRecuperaSenha");

    var url = new URL(window.location);
    var ec = url.searchParams.get("ec");

    defineWL(ec);

    // função que envia as requisições para o servidor
    function sendFetch(){
        $("#load").show();
        return fetch.apply(this, arguments);
    }

    // envia a requisição de login
    $("#formLogin").submit(function(e){
        e.preventDefault();

        sendFetch("./controller/login.php",{
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function(data){
            $("#load").hide();
            $(".msg").addClass("on");
            $(".msg .text").text(data.message);
            if(data.code === 200) {
                location.href=data.route;
            }

        }).catch(function(error){
            $("#load").hide();
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $(".abre-modal").click((e) => {
        e.preventDefault();
        abreModal("modalRecuperaSenha");
        $("#field_novo_email").focus();
    });


    $("#token").on("input", function(){
        if($(this).val().length === 6) {
            $("#btnAlterarSenha").removeAttr("disabled");
        }else{
            $("#btnAlterarSenha").attr("disabled", true);
        }
    });

    function contador(time, botao){
        $("#"+botao).attr("disabled", true).removeClass("cont-finish");
        $("#"+botao+" .text u").show().text("("+time+")");
        let cont = time;
        let interval = setInterval(function(){
            if(cont === 1) {
                clearInterval(interval);
                $("#"+botao).removeAttr("disabled").addClass("cont-finish");
                $("#"+botao+" .text u").hide();
                return;
            }else{
                cont--;
                $("#"+botao+" .text u").show().text("("+cont+")");
                $("#"+botao).attr("disabled", true).removeClass("cont-finish");
            }
        },1000);
    }

    // enviar token
    function sendFetchToken() {
        $("#load2FAEmail, #loadReenviarToken").show();
        $("#btnEnvia2FAEmail .text, #btnReenviarToken .text").hide();
        $("#btnReenviarToken").attr("disabled", true).removeClass("cont-finish");
        $("#btnReenviarToken .text u").show().text("");
        return fetch.apply(this, arguments);
    }

    function enviarToken2FA(form){
        const formulario = document.getElementById(form);
        const ec = $("#id_ec").val();
        sendFetchToken("./controller/gera_token_2fa_senha.php?ec="+ec, {
            method: 'POST',
            body: new FormData(formulario)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code === 502) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#field_novo_email").addClass("field-error");
                $("#btnEnvia2FAEmail .text").show();
                $("#load2FAEmail").hide();
                return;
            }

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                return;
            }
            
            $("#btnEnvia2FAEmail .text, #btnReenviarToken .text").show();
            $("#load2FAEmail, #loadReenviarToken").hide();
            $("#btnReenviarToken .text u").show();

            $("#btnEnvia2FAEmail").attr("disabled", true);

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            $(".email-envio").text($("#field_email_cadastrado").val());
            $("#novo_email").val($("#field_email_cadastrado").val());

            $("#field_novo_email").removeClass("field-error");

            $("#boxEmail").addClass("hide");
            $("#boxToken").removeClass("hide");
            contador(30,"btnReenviarToken");

            $("#token").focus();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    }

    $("#formRecuperaSenha").submit(function (e) {
        e.preventDefault();
        enviarToken2FA("formRecuperaSenha");
    });

    $("#btnReenviarToken").click(function (e) {
        e.preventDefault();
        enviarToken2FA("formRecuperaSenha");
    });

    // alterar e-mail
    function sendFetchSenha() {
        $("#loadAlterarSenha").show();
        $("#btnAlterarSenha .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formConfirma2FASenha").submit(function (e) {
        e.preventDefault();

        sendFetchSenha("./controller/redireciona_alterar_senha.php?chave_ec="+ec, {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code === 502) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#token").addClass("field-error");
                $("#btnAlterarSenha .text").show();
                $("#loadAlterarSenha").hide();
                return;
            }

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                return;
            }
            
            $("#btnAlterarSenha .text").show();
            $("#loadAlterarSenha").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            sessionStorage.setItem("token", data.token);

            setTimeout(function() {
                location.href = data.route;
            }, 1500);

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $("#fechaModalRecuperaSenha, #fechaModalRecuperaSenhaToken").click(() => {
        $("#modalRecuperaSenha").hide();
        $("#boxToken").addClass("hide");
        $("#boxEmail").removeClass("hide");
        $("#formRecuperaSenha")[0].reset();
        $("#formConfirma2FASenha")[0].reset();
    });

});