$(function(){

    recuperaMenus();
    recuperaDados();
    validationForm("formNovoFAQ");
    verificaInputsRequired("formNovoFAQ");
    validationForm("formDadosFAQ");
    verificaInputsRequired("formDadosFAQ");

    var toolbarOptions = [
        ['bold', 'italic', 'underline', 'strike'],
        ['link'],
        [{ 'list': 'ordered'},{'list':'bullet'}, { 'align': []}],
        ['clean']
    ];

    var options = {
        placeholder: 'Digite a resposta...',
        theme: 'snow',
        modules: {
            toolbar: toolbarOptions
        }
    };

    var quill = new Quill(".editor", options);

    var quillDados = new Quill(".editor-dados", options);


    // abre modal de cadastrar estabelecimento
    $("#btnCadastrarFAQ").click(function () {
        abreModal("modalNovoFAQ");
        fetch("./controller/recupera_categorias_faq.php").then((resp) => resp.json()).then(function (dados) {

            var linha = "";

            dados.list.forEach(categoria => {
                linha += `<li><p class="name">${categoria}</p></li>`;
            });

            $("#linhasCategoriaFAQ").html(linha);

        }).catch(function (error) {
            console.log(error);
        });
    });

    $("#fechaModalNovoFAQ").click(() => {
        $("#modalNovoFAQ").hide();
    });

    $("body").on("keyup click",".editor .ql-editor", function(){
        $("#callback_faq").val($(this).html());
        if($("#callback_faq").val() == "<p><br></p>"){
            $("#btnCadastraFAQ").attr("disabled", true);
        }else{
            $("#btnCadastraFAQ").attr("disabled", false);
        }
    });

    $("body").on("keyup click",".editor-dados .ql-editor", function(){
        $("#callback_faq_dados").val($(this).html());
        if($("#callback_faq_dados").val() == "<p><br></p>"){
            $("#btnAtualizaFAQ").attr("disabled", true);
        }else{
            $("#btnAtualizaFAQ").attr("disabled", false);
        }
    });

    function sendFetchDados() {
        $("#btnCadastraFAQ .load").show();
        $("#btnCadastraFAQ .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formNovoFAQ").submit(function (e) {
        e.preventDefault();

        sendFetchDados("./controller/cadastra_faq.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnCadastraFAQ .text").show();
                $("#btnCadastraFAQ .load").hide();
                return;
            }
            
            $("#btnCadastraFAQ .text").show();
            $("#btnCadastraFAQ .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            $('#formNovoFAQ')[0].reset();
            $(".editor .ql-editor").html("");
            $("#formNovoFAQ input").removeClass("input-active");
            $(".modal").hide();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    function sendFetchDetalhes() {
        $("#modalDadosFAQ .load-detalhes").show();
        return fetch.apply(this, arguments);
    }

    $("#listaFAQ").on("click",".abre-detalhes", function () {

        abreModal("modalDadosFAQ");
        const idEstabelecimento = $(this).closest("tr").data("id");

        sendFetchDetalhes("./controller/consulta_faq.php?id="+idEstabelecimento).then((resp) => resp.json()).then(function (dados) {

            if (dados.code) {
                $(".msg").addClass("on");
                $(".msg .text").text(dados.message);
                return;
            }

            $("#field_pergunta_dados").val(dados.pergunta).addClass("input-active");
            $("#field_categoria_dados").val(dados.categoria).addClass("input-active");
            $("#modalDadosFAQ .ql-editor").html(dados.resposta);
            $("#modalDadosFAQ #callback_faq_dados").val(dados.resposta);

            let status;
            dados.status === "0" ? status = "Inativo" : status = "Ativo";

            $("#field_hidden_status").val(dados.status);
            $("#radiosAlteraStatus .radio").removeClass("ativo");
            $(`#radiosAlteraStatus .radio .label:contains(${status})`).closest(".radio").addClass("ativo");

            $("#btnAtualizaFAQ").data("id", dados.id);
            
            $("#modalDadosFAQ .load-detalhes").hide();
            $("#formDadosFAQ").show();

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });

        fetch("./controller/recupera_categorias_faq.php").then((resp) => resp.json()).then(function (dados) {

            var linha = "";

            dados.list.forEach(categoria => {
                linha += `<li><p class="name">${categoria}</p></li>`;
            });

            $("#linhasCategoriaFAQDados").html(linha);

        }).catch(function (error) {
            console.log(error);
        });
    });

    $("#fechaModalDadosFAQ").click(() => {
        closeModalFAQ();
    });

    function closeModalFAQ(){
        $("#modalDadosFAQ .load-detalhes").show();
        $("#modalDadosFAQ").hide();
        $("#formDadosFAQ").hide();
    }

    $("#radiosAlteraStatus .radio").on("click", function(){
        const option = $(this).data("option");
        $("#field_hidden_status").val(option);
        $("#radiosAlteraStatus .radio").removeClass("ativo");
        $(this).addClass("ativo");
        $("#btnAtualizaFAQ").attr("disabled", false);
    });

    function sendFetchAtualizaDados() {
        $("#btnAtualizaFAQ .load").show();
        $("#btnAtualizaFAQ .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formDadosFAQ").submit(function (e) {
        e.preventDefault();

        const idFAQ = $("#btnAtualizaFAQ").data("id");

        sendFetchAtualizaDados("./controller/atualiza_dados_faq.php?id="+idFAQ, {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#btnAtualizaFAQ .text").show();
                $("#btnAtualizaFAQ .load").hide();
                return;
            }
            
            $("#btnAtualizaFAQ .text").show();
            $("#btnAtualizaFAQ .load").hide();

            $(".msg").addClass("on");
            $(".msg .text").text(data.message);

            recuperaDados();
            closeModalFAQ();
            $(".modal").hide();

        }).catch(function (error) {
            console.log(error);
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

    $(".select-box").on("click", function(){
        let alturaTela = window.innerHeight;
        let distanciaTopo = $(this).offset().top;
        let altura = alturaTela - distanciaTopo;
        if(altura < 242){
            $(this).parent().find(".options").addClass("on-top").show();
        }else{
            $(this).parent().find(".options").removeClass("on-top").show();
        }
        let icone = $(this).parent().find(".icon").children("span");
        icone.addClass("rotate");
    });

    // fecha options
    $("body").click(function (e) {
        var condicao = $(e.target).is(".select-box *") || $(e.target).is(".select-box") || $(e.target).is(".options");

        if (!condicao) {
            $(".options").hide();
            $(".select-content .icon span").removeClass("rotate");
        }
    });

    // filtro de options
    $("#field_categoria, #field_categoria_dados").on("keyup", function () {
        $(".select-content .linhas li").removeClass("result-on");

        if ($(this).val() != "") {
            $(".linhas li").hide();
            $(".linhas li:contains-ci('" + $(this).val() + "')").show().addClass("result-on");
            contaResultados();
        } else {
            $(".linhas li").show();
        }
    });

    $.extend($.expr[":"], {
        "contains-ci": function (elem, i, match, array) {
            return (elem.textContent || elem.innerText || $(elem).text() || "").toLowerCase().indexOf((match[3] || "").toLowerCase()) >= 0;
        }
    });

    $("#formNovoFAQ .select-content").on("click",".linhas li", function(){
        $(".select-content .linhas li").removeClass("selected");
        $(this).addClass("selected");
        var option = $(this).children(".name").text();
        $("#field_categoria").val(option).addClass("input-active").removeClass("field-error");
        verificarInputsObrigatorios("formNovoFAQ");
    });

    $("#formDadosFAQ .select-content").on("click",".linhas li", function(){
        $(".select-content .linhas li").removeClass("selected");
        $(this).addClass("selected");
        var option = $(this).children(".name").text();
        $("#field_categoria_dados").val(option).addClass("input-active").removeClass("field-error");
        verificarInputsObrigatorios("formDadosFAQ");
    });

    $("body").on("click",".categoria", function () {
        $(".categoria").removeClass("ativo");
        $(this).addClass("ativo");
        let categoria = $(this).data("categoria");
        recuperaPerguntasPorCategoria(categoria);
    });

});