$(function () {

    validationForm("formCadastro");
    verificaInputsRequired("formCadastro");

    var url = new URL(window.location);
    var ec = url.searchParams.get("ec");

    defineWL(ec);

    var dados_form = {};

    var cadastro_iniciado = localStorage.getItem("cadastro_iniciado");
    var dados_preenchidos = JSON.parse(localStorage.getItem("dados_preenchidos"));

    if (cadastro_iniciado === null) {
        cadastro_iniciado = localStorage.setItem("cadastro_iniciado", false);
    }

    if (dados_preenchidos === null) {
        dados_preenchidos = localStorage.setItem("dados_preenchidos", JSON.stringify({}));
    }

    if(cadastro_iniciado === "true" && dados_preenchidos.nome){

        abreModal("cadastroIniciado");

        $("#continuarCadastro").on("click", function(e){
            e.preventDefault();
            $("#cadastroIniciado").hide();

            $(".input").each(function () {
                let name = $(this).prop("name");
                $(this).val(dados_preenchidos[name]);
                var preenchidos = true;
        
                if ($(this).val().length > 0) {
                    $(this).addClass("input-active");
                }
        
                if ($(this).prop("required") === true) {
                    if (!this.value || $(this).hasClass("field-error")) {
                        preenchidos = false;
                        return false;
                    }
                }
            });

        });

        $("#iniciarNovo").on("click", function(e){
            e.preventDefault();
            $("#cadastroIniciado").hide();
            localStorage.setItem("cadastro_iniciado", false);
            localStorage.setItem("dados_preenchidos", JSON.stringify({}));
        });

        
    }

    // cadastrar parceiro
    function sendFetchDados() {
        $("#loadCadastro").show();
        $("#cadastraUsuario .text").hide();
        return fetch.apply(this, arguments);
    }

    $("#formCadastro").submit(function (e) {
        e.preventDefault();

        sendFetchDados("./controller/cadastra_usuario.php", {
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function (data) {

            if (data.code != 200) {
                $(".msg").addClass("on");
                $(".msg .text").text(data.message);
                $("#cadastraUsuario .text").show();
                $("#loadCadastro").hide();
                return;
            }
            
            $("#cadastraUsuario .text").show();
            $("#loadCadastro").hide();

            $(".email-cadastro").text($("#field_email").val());

            $(".inner-box").addClass("hide");
            $(".cadastro.center-content").removeClass("width-680").addClass("width-400");
            $("#btnIrParaOLogin").attr("href","./login?ec="+ec);
            $("#cadastroRealizadoComSucesso").removeClass("hide");

            localStorage.setItem("cadastro_iniciado", false);
            localStorage.setItem("dados_preenchidos", JSON.stringify({}));

        }).catch(function (error) {
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

});