$(function(){

    validationForm("formCadastrarSenha");

    var url = new URL(window.location);
    var ec = url.searchParams.get("ec");
    var idEc = url.searchParams.get("i");

    defineWL(ec);

    $("#field_senha").on("keyup", function () {
        validaSenha("#btnCadastrarSenha","#field_senha");
    });

    $("#field_senha_confirm").on("keyup", function(){
        if($(this).val() != $("#field_senha").val()){
            $(this).addClass("field-error");
            contaErros("formCadastrarSenha");
            $(".msg").addClass("on");
            $(".msg .text").text("As senhas não correspondem");
        }else{
            $(this).removeClass("field-error");
            contaErros("formCadastrarSenha");
            $(".msg").removeClass("on");
        }
    });

    const urlParams = new URLSearchParams(window.location.search);
    const token = urlParams.get("t");

    if(!token || token.length < 20 || token === "" || token === "null"){
        location.href = "./404";
    }

    const emailToken = atob(token).split(":")[0];
    const idToken = atob(token).split(":")[1];
    const expireToken = atob(token).split(":")[2];
    const nomeToken = atob(token).split(":")[3];

    $("#emailToken").val(emailToken);
    $("#idToken").val(idToken);
    $("#expireToken").val(expireToken);
    $("#nomeToken").val(nomeToken);

    // função que envia as requisições para o servidor
    function sendFetch(){
        $("#load").show();
        return fetch.apply(this, arguments);
    }

    // envia a requisição de login
    $("#formCadastrarSenha").submit(function(e){
        e.preventDefault();

        sendFetch("./controller/cadastra_senha_usuario.php?ec="+idEc,{
            method: 'POST',
            body: new FormData(this)

        }).then((resp) => resp.json()).then(function(data){
            
            $("#load").hide();
            $(".msg").addClass("on");
            $(".msg .text").text(data.message);
            
            if(data.code === 200) {
                setTimeout(function() {
                    location.href = data.route;
                }, 1500);
            }

        }).catch(function(error){
            $("#load").hide();
            $(".msg").addClass("on");
            $(".msg .text").text(error);
        });
    });

});