<?php

// definição das metatags de SEO
$meta_title = "Recuperar senha - MaisDigital Workspace";
$meta_description = "Recuperação de senha";
$meta_canonical = "";
$meta_robots = "noindex, nofollow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/recuperar-senha.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading_login.php"); ?>
<div class="container hide flex" data-route="recuperar-senha">
    <div class="center-content">
        <img class="logo" src="" alt="Logo">
        <div class="inner-box">
            <h3>Recuperar senha</h3>
            <p>Digite a nova senha e não esqueça de guardá-la em um local seguro</p>
            <form class="form" id="formAlterarSenha" method="post">
                <div class="fields gap-2">
                    <div class="row">
                        <div class="input-content" data-input="field_nova_senha" id="container-field_nova_senha">
                            <input required type="password" name="nova_senha" id="field_nova_senha" class="input icon-right">
                            <label for="field_nova_senha">Nova senha</label>
                            <span class="icon action password-off" data-input="field_nova_senha">
                                <span class="off material-icons-round">visibility_off</span>
                            </span>
                            <span class="icon action password-on hide" data-input="field_nova_senha">
                                <span class="on material-icons-round">visibility</span>
                            </span>
                            <div class="toltip left top">
                                <p><b>A senha precisa incluir:</b></p>
                                <ul>
                                    <li id="letraMaiuscula">
                                        <div class="icone red"><span class="material-icons-round">close</span></div>
                                        <div class="text">Uma letra maiúscula</div>
                                    </li>
                                    <li id="numero">
                                        <div class="icone red"><span class="material-icons-round">close</span></div>
                                        <div class="text">Um número</div>
                                    </li>
                                    <li id="caractereEspecial">
                                        <div class="icone red"><span class="material-icons-round">close</span></div>
                                        <div class="text">Um caractere especial</div>
                                    </li>
                                    <li id="oitoCaracteres">
                                        <div class="icone red"><span class="material-icons-round">close</span></div>
                                        <div class="text">Pelo menos 8 caracteres</div>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="row cols2">
                        <div class="input-content" data-input="field_senha_confirm" id="container-field_senha_confirm">
                            <input required type="password" name="senha_confirm" id="field_senha_confirm" class="input icon-right">
                            <label for="field_senha_confirm">Digite novamente</label>
                            <span class="icon action password-off" data-input="field_senha_confirm">
                                <span class="off material-icons-round">visibility_off</span>
                            </span>
                            <span class="icon action password-on hide" data-input="field_senha_confirm">
                                <span class="on material-icons-round">visibility</span>
                            </span>
                        </div>
                    </div>
                    <input type="hidden" name="token" id="token">
                    <button disabled class="botao primary botao-submit" id="btnAtualizaSenha">
                        <span class="text">Alterar senha</span>
                        <span class="load" id="load"></span>
                    </button>
                </div>

            </form>
        </div>
        <p class="">Lembrou a senha? <a id="voltarParaLogin" href="">Fazer login</a></p>
    </div>
    <?php require_once("model/body/message.php"); ?>
</div>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>