<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Recados - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/recados.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="recados" data-route="recados">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main recados">
        <div class="inner-container">
            <div class="title-flex">
                <h3 class="title">
                    Recados
                    <span class="numeroCadastrados">0</span>
                </h3>
                <div class="botao primary auto-width abre-modal" id="btnCadastrarRecado">
                    <span class="load" id="load"></span>
                    <span class="text">Adicionar novo</span>
                </div>
            </div>
            <section class="estabelecimentos-list">
                <div class="card">
                    <div class="empty hide">
                        <?php require_once("./assets/img/empty_recados.svg"); ?>
                        <p>Os recados aparecerão aqui quando forem cadastrados</p>
                    </div>
                    <div class="load-alt center" id="loadRecados"></div>
                    <div class="table-scroll hide" id="tableRecados">
                        <table>
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Recado</th>
                                    <th>Data</th>
                                    <th>Anexos</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody id="listaRecados"></tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
        <?php require_once("model/body/modal_cadastro_recado.php"); ?>
        <?php require_once("model/body/modal_dados_recado.php"); ?>
        <?php require_once("model/body/modal_confirma_exclusao_recado.php"); ?>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>