<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Portais - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/portais.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="portais" data-route="portais">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main portais">
        <div class="inner-container">
            <div class="title-flex">
                <h3 class="title">
                    Portais
                    <span class="numeroCadastrados">0</span>
                </h3>
                <div class="botao primary auto-width abre-modal" id="btnCadastrarPortal">
                    <span class="load" id="load"></span>
                    <span class="text">Cadastrar</span>
                </div>
            </div>
            <section class="filtros mb-3">
                <div class="card">
                    <div class="conteudo">
                        <div class="flex">
                            <form class="form" id="formPesquisaLivre">
                                <div class="fields">
                                    <div class="row">
                                        <div class="input-content">
                                            <input required type="text" name="pesquisa_livre" id="pesquisaLivre" data-key="live" class="input icon-right">
                                            <label for="pesquisaLivre">Pesquise pelo nome ou link</label>
                                            <div class="icon right">
                                                <span class="material-icons-round">search</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>
            <div class="card">
                <div class="load load-portais center" id="loadPortais"></div>
            </div>
            <div class="card hide" id="emptyPortais">
                <div class="empty">
                    <?php require_once("./assets/img/empty_search.svg"); ?>
                    <p>Nenhum portal encontrado</p>
                </div>
            </div>
            <div class="card card-lista-portais hide">
                <div class="conteudo">
                    <ul class="lista portais-list"></ul>
                </div>
            </div>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>
<?php require_once("model/body/modal_cadastro_portal.php"); ?>
<?php require_once("model/body/modal_dados_portal.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>