<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Perfil - Workspace Mais Digital";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/perfil.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="perfil" data-route="perfil">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main">
        <div class="inner-container">
            <h3 class="title">Perfil do usuário</h3>
            <section class="perfil">
                <div class="card">
                    <form class="form" id="formDadosUser" enctype="multipart/form-data" method="post">
                        <p class="titulo mb-3">Dados pessoais</p>
                        <div class="fields">
                            <div class="flex">
                                <input type="file" id="uploadPhoto" name="foto_perfil" accept="image/*" hidden>
                                <input type="hidden" name="delete_photo" id="delete_photo" value="nao">
                                <div class="photo">
                                    <img src="./assets/img/default_profile.svg" alt="Imagem do perfil" id="imgPerfil">
                                    <label for="uploadPhoto" class="icone botao primary auto-width">
                                        <div class="icon">
                                            <span class="material-icons-round">edit</span>
                                        </div>
                                    </label>
                                    <div class="icone botao red auto-width delete hide" id="deleteImage">
                                        <div class="icon">
                                            <span class="material-icons-round">delete</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="fields">
                                    <div class="row cols2">
                                        <div class="input-content">
                                            <input required type="text" name="nome" id="field_nome_representante" class="input field-nome-representante">
                                            <label for="field_nome_representante">Nome</label>
                                        </div>
                                    </div>
                                    <div class="row cols2">
                                        <div class="input-content">
                                            <input required type="text" name="cpf" id="field_cpf" class="input field-cpf mask-cpf">
                                            <label for="field_cpf">Documento</label>
                                        </div>
                                        <div class="input-content">
                                            <input type="text" name="data_nascimento" id="field_dob" class="input mask-date field-data">
                                            <label for="field_dob">Data de nascimento</label>
                                        </div>
                                    </div>
                                    <div class="row cols2">
                                        <div class="input-content">
                                            <input readonly required type="email" name="email" id="field_email" class="input field-email icon-right">
                                            <label for="field_email">E-mail</label>
                                            <span class="icon action abre-modal">
                                                <span class="material-icons-round">edit</span>
                                            </span>
                                        </div>
                                        <div class="input-content">
                                            <input required type="text" name="celular" id="field_celular" class="input mask-phone field-celular">
                                            <label for="field_celular">Celular</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="divider light"></div>
                        <p class="titulo mb-3">Dados de registro</p>
                        <div class="fields">
                            <div class="row cols2">
                                <div class="input-content">
                                    <input readonly type="text" name="status" id="field_status" class="input field-status">
                                    <label for="field_status">Status</label>
                                </div>
                                <div class="input-content">
                                    <input readonly type="text" name="perfil" id="field_perfil" class="input field-perfil">
                                    <label for="field_perfil">Perfil</label>
                                </div>
                                <div class="input-content">
                                    <input readonly type="text" name="data_cadastro" id="field_data_cadastro" class="input field-data_cadastro">
                                    <label for="field_data_cadastro">Data de cadastro</label>
                                </div>
                            </div>
                        </div>
                        <div class="row-botao sticky">
                            <button disabled type="submit" class="botao primary botao-submit auto-width" id="btnAtualizaDados">
                                <span class="text">Salvar atualizações</span>
                                <span class="load" id="loadSubmit"></span>
                            </button>
                        </div>
                    </form>
                </div>
                <div class="card">
                    <form class="form" id="formAlterarSenha">
                        <p class="titulo mb-3">Alterar senha</p>
                        <div class="fields">
                            <div class="row cols2">
                                <div class="input-content" data-input="field_senha" id="container-field_senha">
                                    <input required type="password" name="senha_atual" id="field_senha" class="input icon-right">
                                    <label for="field_senha">Senha atual</label>
                                    <span class="icon action password-off" data-input="field_senha">
                                        <span class="off material-icons-round">visibility_off</span>
                                    </span>
                                    <span class="icon action password-on hide" data-input="field_senha">
                                        <span class="on material-icons-round">visibility</span>
                                    </span>
                                </div>
                                <div class="input-content" data-input="field_nova_senha" id="container-field_nova_senha">
                                    <input required type="password" name="nova_senha" id="field_nova_senha" class="input icon-right">
                                    <label for="field_nova_senha">Nova senha</label>
                                    <span class="icon action password-off" data-input="field_nova_senha">
                                        <span class="off material-icons-round">visibility_off</span>
                                    </span>
                                    <span class="icon action password-on hide" data-input="field_nova_senha">
                                        <span class="on material-icons-round">visibility</span>
                                    </span>
                                    <div class="toltip left top">
                                        <p>A senha precisa incluir:</p>
                                        <ul>
                                            <li id="letraMaiuscula">
                                                <div class="icone red"><span class="material-icons-round">close</span></div>
                                                <div class="text">Uma letra maiúscula</div>
                                            </li>
                                            <li id="numero">
                                                <div class="icone red"><span class="material-icons-round">close</span></div>
                                                <div class="text">Um número</div>
                                            </li>
                                            <li id="caractereEspecial">
                                                <div class="icone red"><span class="material-icons-round">close</span></div>
                                                <div class="text">Um caractere especial</div>
                                            </li>
                                            <li id="oitoCaracteres">
                                                <div class="icone red"><span class="material-icons-round">close</span></div>
                                                <div class="text">Pelo menos 8 caracteres</div>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" id="ec_usuario_logado">
                        <div class="row-botao sticky">
                            <button disabled type="submit" class="botao primary botao-submit auto-width" id="btnAtualizaSenha">
                                <span class="text">Atualizar senha</span>
                                <span class="load" id="loadSalvarSenha"></span>
                            </button>
                        </div>
                    </form>
                </div>
            </section>
        </div>
        <?php require_once("model/body/modal_atualiza_email.php"); ?>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>