<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Parceiros - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/parceiros.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="parceiros" data-route="parceiros">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main parceiros">
        <div class="inner-container">
            <div class="title-flex">
                <h3 class="title">
                    Parceiros
                    <span class="numeroCadastrados">0</span>
                </h3>
                <div class="botao primary auto-width abre-modal" id="btnCadastrarParceiro">
                    <span class="load" id="load"></span>
                    <span class="text">Cadastrar</span>
                </div>
            </div>
            <section class="filtros mb-3">
                <div class="card">
                    <div class="conteudo">
                        <div class="flex">
                            <form class="form" id="formPesquisaLivre">
                                <div class="fields">
                                    <div class="row">
                                        <div class="input-content">
                                            <input required type="text" name="pesquisa_livre" id="pesquisaLivre" data-key="live" class="input icon-right">
                                            <label for="pesquisaLivre">Nome do parceiro</label>
                                            <div class="icon right">
                                                <span class="material-icons-round">search</span>
                                            </div>
                                        </div>
                                        <button type="button" class="botao secondary auto-width" id="resetaFiltros">
                                            <span class="text">Limpar</span>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>
            <section class="parceiros-list">
                <div class="card">
                    <div class="empty hide">
                        <?php require_once("./assets/img/empty_search.svg"); ?>
                        <p>Os parceiros aparecerão aqui quando forem cadastrados</p>
                    </div>
                    <div class="empty-search hide">
                        <p>Nenhum parceiro encontrado com os termos informados</p>
                    </div>
                    <div class="load-alt center" id="loadParceiros"></div>
                    <div class="table-scroll hide" id="tableParceiros">
                        <table id="parceirosTable">
                            <thead>
                                <tr>
                                    <th>Logo</th>
                                    <th>Nome</th>
                                    <th>Site</th>
                                    <th>E-mail</th>
                                    <th>Status</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody id="listaParceiros"></tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>
<?php require_once("model/body/modal_cadastro_parceiro.php"); ?>
<?php require_once("model/body/modal_dados_parceiro.php"); ?>
<?php require_once("model/body/modal_altera_status_parceiro.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>