<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Notas Fiscais - VP Empresas";
$meta_description = "";
$meta_canonical = "https://parceiros.vamosparcelar.com.br/nota-fiscal";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/nf.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide nf" data-menu="nota_fiscal" data-route="nota-fiscal">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main">
        <div class="inner-container">
            <div class="title-flex">
                <h3 class="title">Notas fiscais</h3>
                <div class="botao primary auto-width abre-modal" id="btnModalNF">
                    <span class="load" id="load"></span>
                    <span class="icon"><span class="material-icons-round">note_add</span></span>
                    <span class="text">Cadastrar NF</span>
                </div>
            </div>
            <section class="historico">
                <div class="card">
                    <div class="conteudo">
                        <div class="load center" id="loadNF"></div>
                        <div class="notas-fiscais">
                            <div class="load center load-nf" id="loadNF"></div>
                            <div class="nfList">
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <?php require_once("model/body/modal_nf.php"); ?>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>