<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Portais - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/portais.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="lista-portais" data-route="lista-portais">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main portais">
        <div class="inner-container">
            <div class="title-flex">
                <h3 class="title">
                    Portais
                </h3>
            </div>
            <section class="filtros mb-3">
                <div class="card">
                    <div class="conteudo">
                        <div class="flex">
                            <form class="form" id="formPesquisaLivre">
                                <div class="fields">
                                    <div class="row">
                                        <div class="input-content">
                                            <input required type="text" name="pesquisa_livre" id="pesquisaLivreCards" data-key="live" class="input icon-right">
                                            <label for="pesquisaLivre">Nome do portal</label>
                                            <div class="icon right">
                                                <span class="material-icons-round">search</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>
            <div class="card">
                <div class="load load-portais center" id="loadPortais"></div>
            </div>
            <section class="portais-list-flex list-flex hide">
            </section>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>