<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Manuais - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/manuais.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="lista-manuais" data-route="lista-manuais">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main manuais">
        <div class="inner-container">
            <div class="banner mb-3 banner-manuais">
                <div class="content-banner">
                    <div class="text">
                        <h3 class="title">Manuais</h3>
                        <p>Navegue em nossa coleção de manuais para encontrar todas as informações necessárias sobre nossos produtos.</p>
                    </div>
                </div>
            </div>
            <section class="filtros mb-3">
                <div class="card">
                    <div class="conteudo">
                        <div class="flex">
                            <form class="form" id="formPesquisaLivre">
                                <div class="fields">
                                    <div class="row">
                                        <div class="input-content">
                                            <input type="text" name="pesquisa_livre" id="pesquisaLivreCards" data-key="live" class="input icon-right">
                                            <label for="pesquisaLivre">Pesquise pelo nome do manual</label>
                                            <div class="icon right">
                                                <span class="material-icons-round">search</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>
            <div class="card">
                <div class="load load-manuais center" id="loadManual"></div>
            </div>
            <div class="card hide" id="emptyManual">
                <div class="empty">
                    <?php require_once("./assets/img/empty_search.svg"); ?>
                    <p>Nenhum manual encontrado</p>
                </div>
            </div>
            <section class="manuais-list-flex list-flex hide">
            </section>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>