<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Imagens - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/artes.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="artes" data-route="artes">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main artes">
        <div class="inner-container">
            <div class="title-flex">
                <h3 class="title">
                    Imagens
                    <span class="numeroCadastrados">0</span>
                </h3>
                <div class="botao primary auto-width abre-modal" id="btnCadastrarArte">
                    <span class="load" id="load"></span>
                    <span class="text">Adicionar</span>
                </div>
            </div>
            <section class="estabelecimentos-list">
                <div class="card">
                    <div class="empty hide">
                        <?php require_once("./assets/img/empty_search.svg"); ?>
                        <p>Os artes aparecerão aqui quando forem cadastrados</p>
                    </div>
                    <div class="load-alt center" id="loadArte"></div>
                    <div class="table-scroll hide" id="tableArte">
                        <table>
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Categoria</th>
                                    <th>Data</th>
                                    <th>Status</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody id="listaArte"></tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
<?php require_once("model/body/modal_cadastro_arte.php"); ?>
<?php //require_once("model/body/modal_dados_arte.php"); ?>
<?php //require_once("model/body/modal_confirma_exclusao_arte.php"); ?>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>