<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Home - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/dashboard.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="home" data-route="home">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main home">
        <div class="inner-container">
            <div class="banner mb-3">
                <div class="content-banner">
                    <div class="text">
                        <h3 class="title">Olá, <u></u></h3>
                        <p>Seja bem-vindo(a) ao Workspace da <span id="nomeEC"></span>. Por aqui você vai ficar por dentro de todas as novidades da nossa empresa em primeira mão.</p>
                    </div>
                </div>
            </div>
            <section class="section-row">
                <div class="column-60">
                    <div class="card link">
                        <div class="conteudo">
                            <p class="titulo">Link de cadastro</p>
                            <p class="margin">Envie o link abaixo para outras pessoas se cadastrarem no Workspace.</p>
                            <div class="input-container">
                                <input type="text" readonly class="input" id="link" value="">
                                <input type="hidden" id="ghost">
                                <div class="botao primary copiar small auto-width">
                                    <div class="icon"><span class="material-icons-round">copy</span></div>
                                    <div class="text">Copiar</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card recados">
                        <div class="conteudo">
                            <p class="titulo mb-2">Último recado</p>
                            <div class="load load-recados center" id="loadRecados"></div>
                            <div class="empty hide" id="emptyRecados">
                                <?php require_once("./assets/img/empty_recados.svg"); ?>
                                <p>Nenhum recado encontrado</p>
                            </div>
                            <div class="recado hide">
                                <div class="head-recado">
                                    <div class="flex">
                                        <div class="avatar">
                                            <img id="avatarRecado" src="" alt="Avatar">
                                        </div>
                                        <div>
                                            <p class="nome" id="nomeECRecado"></p>
                                            <div class="data mobile" id="dataRecadoMobile"></div>
                                        </div>
                                    </div>
                                    <div class="data desktop" id="dataRecado"></div>
                                </div>
                                <div class="body-recado">
                                    <div class="texto-recado"></div>
                                    <div class="imagem hide" id="imagemRecado">
                                        <img src="" alt="Imagem">
                                    </div>
                                    <div class="anexos hide">
                                        <a href="" class="link botao secondary hide">
                                            <div class="icon"><span class="material-symbols-rounded">link</span></div>
                                            <p class="text">Acessar o link</p>
                                        </a>
                                        <a href="" class="arquivo botao secondary hide" download>
                                            <div class="icon"><span class="material-symbols-rounded">draft</span></div>
                                            <p class="text">Baixar o arquivo</p>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="column-40">
                    <div class="card blog">
                        <div class="conteudo">
                            <p class="titulo">Blog Mais Digital</p>
                            <p class="mb-2">Acesse e fique por dentro de todas as novidades do mundo financeiro.</p>
                            <a target="_blank" class="botao primary" id="linkAcessoBlogMaisDigital">
                                <div class="text">Acessar o blog</div>
                            </a>
                        </div>
                    </div>
                    <div class="card users">
                        <div class="conteudo">
                            <p class="titulo">Usuários</p>
                            <div class="load load-usuarios center" id="loadUsuarios"></div>
                            <div class="empty hide" id="emptyUsers">
                                <?php require_once("./assets/img/empty_usuarios.svg"); ?>
                                <p>Nenhum usuário encontrado</p>
                            </div>
                            <ul class="lista hide" id="listaUsuarios"></ul>
                            <a href="./lista/usuarios" class="botao primary mt-3 hide" id="btnVerUsuarios">
                                <div class="text">Ver todos</div>
                            </a>
                        </div>
                    </div>

                </div>
            </section>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>
<?php require_once("model/body/modal_imagem.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>