<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "FAQ - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/faq.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="faq" data-route="faq">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main faq">
        <div class="inner-container">
            <div class="title-flex">
                <h3 class="title">
                    Perguntas frequentes
                    <span class="numeroCadastrados">0</span>
                </h3>
                <div class="botao primary auto-width abre-modal" id="btnCadastrarFAQ">
                    <span class="load" id="load"></span>
                    <span class="text">Adicionar nova</span>
                </div>
            </div>
            <section class="estabelecimentos-list">
                <div class="card">
                    <div class="empty hide">
                        <?php require_once("./assets/img/empty_search.svg"); ?>
                        <p>As perguntas aparecerão aqui quando forem cadastrados</p>
                    </div>
                    <div class="load-alt center" id="loadFAQ"></div>
                    <div class="table-scroll hide" id="tableFAQ">
                        <table>
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Pergunta</th>
                                    <th>Categoria</th>
                                    <th>Status</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody id="listaFAQ"></tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>
<?php require_once("model/body/modal_cadastro_faq.php"); ?>
<?php require_once("model/body/modal_dados_faq.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>