<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Estabelecimentos - Workspace";
$meta_description = "";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/estabelecimentos.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="estabelecimentos" data-route="estabelecimentos">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main estabelecimentos">
        <div class="inner-container">
            <div class="title-flex">
                <h3 class="title">
                    Estabelecimentos
                    <span class="numeroCadastrados">0</span>
                </h3>
                <div class="botao primary auto-width abre-modal" id="btnCadastrarEstabelecimento">
                    <span class="load" id="load"></span>
                    <span class="text">Cadastrar</span>
                </div>
            </div>
            <section class="filtros">
                <div class="card">
                    <div class="conteudo">
                        <div class="flex">
                            <form class="form" id="formPesquisaLivre">
                                <div class="fields">
                                    <div class="row">
                                        <div class="input-content">
                                            <input required type="text" name="pesquisa_livre" id="pesquisaLivre" data-key="live" class="input icon-right">
                                            <label for="pesquisaLivre">Nome do estabelecimento</label>
                                            <div class="icon right">
                                                <span class="material-icons-round">search</span>
                                            </div>
                                        </div>
                                        <div class="input-content">
                                            <input required type="text" name="pesquisa_cnpj" id="pesquisaCNPJ" data-key="live" class="input icon-right mask-cnpj">
                                            <label for="pesquisaCNPJ">CNPJ</label>
                                            <div class="icon right">
                                                <span class="material-icons-round">search</span>
                                            </div>
                                        </div>
                                        <div class="input-content">
                                            <select class="select wide input-active" id="selectUF">
                                                <option value="Todos">Todos</option>
                                                <option value="Acre">Acre</option>
                                                <option value="Alagoas">Alagoas</option>
                                                <option value="Amapá">Amapá</option>
                                                <option value="Amazonas">Amazonas</option>
                                                <option value="Bahia">Bahia</option>
                                                <option value="Ceará">Ceará</option>
                                                <option value="Distrito Federal">Distrito Federal</option>
                                                <option value="Espírito Santo">Espírito Santo</option>
                                                <option value="Goiás">Goiás</option>
                                                <option value="Maranhão">Maranhão</option>
                                                <option value="Mato Grosso">Mato Grosso</option>
                                                <option value="Mato Grosso do Sul">Mato Grosso do Sul</option>
                                                <option value="Minas Gerais">Minas Gerais</option>
                                                <option value="Pará">Pará</option>
                                                <option value="Paraíba">Paraíba</option>
                                                <option value="Paraná">Paraná</option>
                                                <option value="Pernambuco">Pernambuco</option>
                                                <option value="Piauí">Piauí</option>
                                                <option value="Rio de Janeiro">Rio de Janeiro</option>
                                                <option value="Rio Grande do Norte">Rio Grande do Norte</option>
                                                <option value="Rio Grande do Sul">Rio Grande do Sul</option>
                                                <option value="Rondônia">Rondônia</option>
                                                <option value="Roraima">Roraima</option>
                                                <option value="Santa Catarina">Santa Catarina</option>
                                                <option value="São Paulo">São Paulo</option>
                                                <option value="Sergipe">Sergipe</option>
                                                <option value="Tocantins">Tocantins</option>
                                            </select>
                                            <label for="selectUF">Estado</label>
                                        </div>
                                        <button type="button" class="botao secondary auto-width" id="resetaFiltros">
                                            <span class="text">Limpar</span>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </section>
            <section class="estabelecimentos-list">
                <div class="card">
                    <div class="empty hide" id="emptyEstabelecimentos">
                        <?php require_once("./assets/img/empty_estabelecimentos.svg"); ?>
                        <p>Os estabelecimentos aparecerão aqui quando forem cadastrados</p>
                    </div>
                    <div class="empty-search hide">
                        <?php require_once("./assets/img/empty_search.svg"); ?>
                        <p>Nenhum estabelecimento encontrado com os termos informados</p>
                    </div>
                    <div class="load-alt center" id="loadEstabelecimentos"></div>
                    <div class="table-scroll hide" id="tableEstabelecimentos">
                        <table id="estabelecimentosTable">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Nome</th>
                                    <th>CNPJ</th>
                                    <th>Estado</th>
                                    <th>Status</th>
                                    <th>Ações</th>
                                </tr>
                            </thead>
                            <tbody id="listaEstabelecimentos"></tbody>
                        </table>
                    </div>
                </div>
            </section>
        </div>
        <?php require_once("model/body/modal_cadastro_estabelecimento.php"); ?>
        <?php require_once("model/body/modal_dados_estabelecimento.php"); ?>
        <?php require_once("model/body/modal_altera_status.php"); ?>
        <?php require_once("model/body/modal_envia_email.php"); ?>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>