<?php

require_once("./controller/auth.php");
require_once("./controller/permission.php");

// definição das metatags de SEO
$meta_title = "Dados da empresa - VP Empresas";
$meta_description = "";
$meta_canonical = "https://parceiros.vamosparcelar.com.br/perfil";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/dados-empresa.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<?php require_once("model/body/loading.php"); ?>
<div class="container hide" data-menu="dados_empresa">
    <?php require_once("model/body/sidebar.php"); ?>
    <?php require_once("model/body/header.php"); ?>
    <main class="main">
        <div class="inner-container">
            <div class="title-flex">
                <h3 class="title">Dados da empresa</h3>
                <div class="botao primary auto-width abre-modal" id="btnEditarDados">
                    <span class="load" id="load"></span>
                    <span class="icon"><span class="material-icons-round">mode_edit</span></span>
                    <span class="text">Editar dados</span>
                </div>
            </div>
            <section class="sobre-empresa">
                <div class="card">
                    <div class="conteudo">
                        <p class="titulo margin">Dados de registro</p>
                        <div class="dados">
                            <div class="left">
                                <div class="dado" id="cnpj">
                                    <p class="chave">CNPJ:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="area_atuacao">
                                    <p class="chave">Área de atuação:</p>
                                    <p class="valor"></p>
                                </div>
                            </div>
                            <div class="right">
                                <div class="dado" id="razao_social">
                                    <p class="chave">Razão social:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="nome_fantasia">
                                    <p class="chave">Nome fantasia:</p>
                                    <p class="valor"></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="conteudo">
                        <p class="titulo margin">Representante legal</p>
                        <div class="dados">
                            <div class="left">
                                <div class="dado" id="nome">
                                    <p class="chave">Nome:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="data_nascimento">
                                    <p class="chave">Data de nascimento:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="email">
                                    <p class="chave">E-mail:</p>
                                    <p class="valor"></p>
                                </div>
                            </div>
                            <div class="right">
                                <div class="dado" id="cpf">
                                    <p class="chave">CPF:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="celular">
                                    <p class="chave">Celular:</p>
                                    <p class="valor"></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="conteudo">
                        <p class="titulo margin">Endereço</p>
                        <div class="dados">
                            <div class="left">
                                <div class="dado" id="cep">
                                    <p class="chave">CEP:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="numero">
                                    <p class="chave">Número:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="bairro">
                                    <p class="chave">Bairro:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="uf">
                                    <p class="chave">UF:</p>
                                    <p class="valor"></p>
                                </div>
                            </div>
                            <div class="right">
                                <div class="dado" id="logradouro">
                                    <p class="chave">Logradouro:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="complemento">
                                    <p class="chave">Complemento:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="cidade">
                                    <p class="chave">Cidade:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="ponto_referencia">
                                    <p class="chave">Ponto de referência:</p>
                                    <p class="valor"></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="conteudo">
                        <p class="titulo margin">Dados bancários</p>
                        <div class="dados">
                            <div class="left">
                                <div class="dado" id="banco">
                                    <p class="chave">Banco:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="agencia">
                                    <p class="chave">Agência:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="pix">
                                    <p class="chave">Chave PIX:</p>
                                    <p class="valor"></p>
                                </div>
                            </div>
                            <div class="right">
                                <div class="dado" id="tipo_conta">
                                    <p class="chave">Tipo de conta:</p>
                                    <p class="valor"></p>
                                </div>
                                <div class="dado" id="conta">
                                    <p class="chave">Conta:</p>
                                    <p class="valor"></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </section>
        </div>
        <?php require_once("model/body/modal_dados_empresa.php"); ?>
        <?php require_once("model/body/modal_pesquisa_bancos.php"); ?>
    </main>
</div>
<?php require_once("model/body/message.php"); ?>

<!-- inluindo o footer da página -->
<?php require_once("model/footer/footer.php"); ?>

</html>