<?php

require_once("auth.php");
require_once("functions.php");
require_once("version.php");


$dados = consulta_usuario_logado($id_usuario);
$data_cadastro_formatada = formata_data($dados["data_cadastro"]);
$ultimo_acesso_formatado = formata_data($dados["ultimo_acesso"]);

$server_name = $_SERVER["SERVER_NAME"];

if ($server_name == "localhost") {
    $repo_name = explode("/", $_SERVER["PHP_SELF"])[1];
    $url = $base = "https://" . $server_name . "/" . $repo_name . "/";
} else {
    $url = $base = "https://" . $server_name . "/";
    $repo_name = null;
}

$response = array(
    "code" => 200,
    "usuario" => [
        "id" => $dados["id_usuario"],
        "nome" => $dados["nome"],
        "documento" => $dados["documento"],
        "email" => $dados["email_usuario"],
        "celular" => $dados["celular"],
        "data_nascimento" => $dados["data_nascimento"],
        "status" => $dados["status_usuario"],
        "data_cadastro" => $data_cadastro_formatada,
        "ultimo_acesso" => $ultimo_acesso_formatado,
        "perfil" => $dados["perfil_usuario"],
        "foto_perfil" => $dados["foto_perfil"]
    ],
    "estabelecimento" => [
        "id" => $dados["id_estabelecimento"],
        "nome_fantasia" => $dados["nome_fantasia"],
        "cnpj" => $dados["cnpj"],
        "razao_social" => $dados["razao_social"],
        "cep" => $dados["cep"],
        "logradouro" => $dados["logradouro"],
        "numero" => $dados["numero"],
        "complemento" => $dados["complemento"],
        "bairro" => $dados["bairro"],
        "cidade" => $dados["cidade"],
        "uf" => $dados["uf"],
        "site" => $dados["site"],
        "status" => $dados["status"],
        "email" => $dados["email"],
        "chave" => $dados["chave"]
    ],
    "ambiente" => [
        "url" => $url,
        "repositorio" => $repo_name,
        "versao" => $version
    ],
    "opcoes" => [
        "blog_mais_digital" => $dados["blog_bb"]
    ]
);

echo json_encode($response);
return true;
