<?php

// definição das metatags de SEO
$meta_title = "Cadastro - Workspace";
$meta_description = "Cadastre-se!";
$meta_canonical = "";
$meta_robots = "index, follow";
$meta_feature_image = "";
$page_favicon = "";

// definição dos sripts
$script = "./src/js/cadastro.js";
$functions = true;

?>

<!DOCTYPE html>
<html lang="pt-BR">

<!-- incluindo o head da página -->
<?php require_once("model/head/head.php"); ?>

<div class="container flex" data-route="cadastro">
    <div class="center-content width-680 cadastro">
        <img class="logo" src="" alt="Logo">
        <form class="form" id="formCadastro" method="post" action="./controller/cadastra_usuario.php">
            <div class="inner-box">
                <h3>Cadastro no Workspace</h3>
                <p class="mb-6">Preencha os dados abaixo para realizar seu cadastro no Workspace.</p>
                <div class="fields">
                    <div class="row">
                        <div class="card border analise flex small">
                            <div class="icone"><span class="material-icons-round">info</span></div>
                            <div class="conteudo">
                                <p class="descricao">O e-mail informado será utilizado para realizar login na plataforma.</p>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="input-content">
                            <input required type="text" name="nome" id="field_nome" class="input">
                            <label for="field_nome">Nome completo</label>
                        </div>
                    </div>
                    <div class="row">
                        <div class="input-content">
                            <input required type="email" name="email" id="field_email" class="input field-email">
                            <label for="field_email">E-mail</label>
                        </div>
                        <div class="input-content">
                            <input required type="text" name="cpf" id="field_cpf" class="input field-cpf mask-cpf">
                            <label for="field_cpf">CPF</label>
                        </div>
                    </div>
                    <div class="row">
                        <div class="input-content">
                            <input required type="text" name="celular" id="field_celular" class="input field-celular mask-phone">
                            <label for="field_celular">Celular</label>
                        </div>
                        <div class="input-content">
                            <input type="text" name="data_nascimento" id="field_data_nascimento" class="input field-data mask-date">
                            <label for="field_data_nascimento">Data de nascimento</label>
                        </div>
                    </div>
                    <div class="row gap-small">
                        <button disabled type="submit" class="botao primary botao-submit" id="cadastraUsuario">
                            <span class="text">Finalizar cadastro</span>
                            <span class="load" id="loadCadastro"></span>
                        </button>
                    </div>
                    <input type="hidden" name="estabelecimento" id="ec_cadastro">
                </div>
            </div>
            <div class="inner-box hide" id="cadastroRealizadoComSucesso">
                <div class="icone-head success center">
                    <span class="material-icons-round">check_circle</span>
                </div>
                <h3 class="title mb-3 center">Cadastro realizado com sucesso!</h3>
                <p class="center mb-3">Seu cadastro no Workspace foi realizado com sucesso. Enviamos um e-mail para <span class="email-cadastro"></span> com informações sobre a criação da sua senha de acesso.</p>
                <a href="" class="botao primary mt-5" id="btnIrParaOLogin">
                    <span class="text">Ir para o login</span>
                    <span class="load" id="load"></span>
                </a>
            </div>
        </form>
        <?php require_once("model/body/message.php"); ?>
        <?php require_once("model/body/modal_cadastro.php"); ?>
    </div>

    <!-- inluindo o footer da página -->
    <?php require_once("model/footer/footer.php"); ?>

</html>